<div class="modal fade" id="balanceModal" tabindex="-1" aria-labelledby="balanceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="balanceModalLabel">{{ __('Modify User Balance') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('admin.user.update-balance') }}" method="POST">
                    @csrf
                    <input type="hidden" name="user_id" value="{{ $user->id }}">

                    {{-- Wallet Selection --}}
                    <div class="mb-3">
                        <label class="form-label" for="walletSelect">{{ __('Select Wallet') }}</label>
                        <select class="form-select" id="walletSelect" name="wallet_id" required>
                            <option value="" disabled selected>{{ __('Choose a Wallet') }}</option>
                            @foreach($user->wallets as $wallet)
                                <option value="{{ $wallet->id }}" data-currency="{{ $wallet->currency->code }}">
                                    {{ $wallet->currency->code }} {{ __('Wallet') }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Transaction Type --}}
                    <div class="mb-3">
                        <label class="form-label">{{ __('Transaction Type') }}</label>
                        <div class="d-flex border rounded p-2">
                            <div class="form-check me-3">
                                <input class="form-check-input" type="radio" name="transaction_type" id="addFunds" value="add" required>
                                <label class="form-check-label" for="addFunds">{{ __('Add Balance') }}</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="transaction_type" id="deductFunds" value="subtract" required>
                                <label class="form-check-label" for="deductFunds">{{ __('Subtract Balance') }}</label>
                            </div>
                        </div>
                    </div>

                    {{-- Amount Input with Dynamic Currency Code --}}
                    <div class="mb-3">
                        <label class="form-label" for="amountInput">{{ __('Amount') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="amountInput" name="amount"
                                   oninput="this.value = validateDouble(this.value)" required>
                            <span class="input-group-text" id="currencyCode">{{ __('Not Selected') }}</span>
                        </div>
                    </div>

                    {{-- Note Input --}}
                    <div class="mb-3">
                        <label class="form-label" for="noteInput">{{ __('Note (Optional)') }}</label>
                        <textarea class="form-control" id="noteInput" name="note" rows="3"
                                  placeholder="{{ __('Enter a note...') }}"></textarea>
                    </div>

                    {{-- Submit Button --}}
                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary">
                            <x-icon name="check" height="20"/> {{ __('Update Balance') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

