<div class="modal fade" id="notifyUserModal" tabindex="-1" aria-labelledby="notifyUserModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="notifyUserModalLabel">{{ __('Notify User') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.notifications.notifyToUser.send') }}" method="POST"
                  onsubmit="disableSubmitButton(this, '{{ __('Processing...') }}')">
                @csrf
                <input type="hidden" name="user_id" value="{{ $user->id }}">
                <div class="modal-body">
                    <div class="row g-3">
                        
                        <!-- Notification Type -->
                        <div class="col-md-12">
                            <label for="modal_notify_type" class="form-label">{{ __('Notification Type') }}</label>
                            <select id="modal_notify_type" name="notify_type" class="form-select">
                                <option value="email">{{ __('Email') }}</option>
                                <option value="push">{{ __('Push Notification') }}</option>
                            </select>
                        </div>
                        
                        <!-- Title Field -->
                        <div class="col-12" id="modal_title_row">
                            <label for="title" class="form-label">{{ __('Title') }}</label>
                            <input type="text" id="title" name="title" class="form-control" placeholder="Notification title...">
                        </div>
                        
                        
                        <!-- Message -->
                        <div class="col-12">
                            <label for="message" class="form-label">{{ __('Message') }}</label>
                            <textarea id="message" name="message" class="form-control" rows="4" placeholder="Write your message here..." required></textarea>
                        </div>
                        
                        <!-- Schedule At -->
                        <div class="col-md-12">
                            <label for="schedule_at" class="form-label">{{ __('Schedule At') }}</label>
                            <input type="datetime-local" id="schedule_at" name="schedule_at" class="form-control">
                        </div>
                        
                    
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        <span class="submit-btn">
                             <x-icon name="send" height="20"/>
                        </span>
                        {{ __('Send Notification') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@push('scripts')
    <script>
        "use strict";
        document.addEventListener('DOMContentLoaded', function () {
            const notifyType = document.getElementById('modal_notify_type');
            const titleRow = document.getElementById('modal_title_row');
            
            function toggleModalTitleField() {
                if (notifyType.value === 'push') {
                    titleRow.classList.add('d-none');
                } else {
                    titleRow.classList.remove('d-none');
                }
            }
            
            // Initial check
            toggleModalTitleField();
            
            // On change event
            notifyType.addEventListener('change', toggleModalTitleField);
        });
    </script>
@endpush
