<div class="d-flex justify-content-end mb-3">
    @php
        $routeName = Route::currentRouteName();
        $route = route($routeName);

        $statusFilter = !in_array($routeName, ['admin.user.active', 'admin.user.suspended']);
        $kycFilter    = $routeName !== 'admin.user.kyc-unverified';
        $emailFilter  = $routeName !== 'admin.user.unverified';
    @endphp
    
    <form action="{{ $route }}" method="GET" class="row g-3 align-items-end">
        {{-- Role Filter --}}
        <div class="col-auto">
            <x-form.select
                name="role"
                :label="__('Account Role')"
                class="form-select pe-5"
                :options="\App\Enums\UserRole::options()"
                :selected="request('role', 'all')"
            />
        </div>
        
        {{-- Status Filter --}}
        @if($statusFilter)
            <div class="col-auto">
                <x-form.select
                    name="status"
                    :label="__('Account Status')"
                    class="form-select pe-5"
                    :options="\App\Enums\UserStatus::options()"
                    :selected="request('status', 'all')"
                />
            </div>
        @endif
        
        {{-- KYC Filter --}}
        @if($kycFilter)
            <div class="col-auto">
                <x-form.select
                    name="kyc_status"
                    :label="__('KYC Status')"
                    class="form-select pe-5"
                    :options="App\Enums\KycStatus::options()"
                    :selected="request('kyc_status', 'all')"
                />
            </div>
        @endif
        
        {{-- Email Filter --}}
        @if($emailFilter)
            <div class="col-auto">
                <x-form.select
                    name="email_verified"
                    :label="__('Email Status')"
                    class="form-select pe-5"
                    :options="[
                        '0'   => __('Unverified'),
                        '1'   => __('Verified'),
                    ]"
                    :selected="request('email_verified', 'all')"
                />
            </div>
        @endif
        
        {{-- Search Input --}}
        <div class="col-auto">
            <div class="input-group">
                <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                       placeholder="{{ __('Search') }}..." aria-label="{{ __('Search') }}">
                <button type="submit" class="btn btn-primary">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
            </div>
        </div>
    </form>
</div>


