<script>
    "use strict";
    (function($) {
        $(document).ready(() => {
            // Show up to second child level by default (root = 0, child = 1, grandchild = 2)
            $(".ref-tree-ul").each(function() {
                let $this = $(this);
                let depth = $this.parents(".ref-tree-ul").length;
                if (depth < 2) {
                    $this.show();
                    $this.prev(".js-toggle-node").addClass("expanded");
                }
            });

            // Toggle deeper levels on click
            $(".ref-tree").on("click", ".js-toggle-node", function(e) {
                e.preventDefault();
                let $childUl = $(this).next(".ref-tree-ul");
                if ($childUl.length) {
                    $childUl.toggle();
                    $(this).toggleClass("expanded", $childUl.is(":visible"));
                }
            });
        });
    })(jQuery);
</script>
