@extends('backend.user.manage')
@section('user_manage_content')
    @if($referrals->isNotEmpty())
        <div class="ref-tree">
            <ul class="ref-tree-ul">
                <!-- Root user -->
                <li class="ref-tree-item ref-tree-root">
                    <a href="javascript:void(0);" class="ref-tree-link js-toggle-node">
                        <div class="ref-tree-info">
                            <img src="{{ asset($user->avatar_alt) }}"
                                 alt="Avatar" class="ref-tree-img">
                            <div class="ref-tree-details">
                                <strong>{{ $user->name }} ({{ $user->username }})</strong>
                                <span>{{ __('Referrals : :count', ['count' => $referrals->count()]) }}</span>
                            </div>
                        </div>
                        <i class="fas fa-chevron-right ref-tree-icon"></i>
                    </a>

                    <ul class="ref-tree-ul">
                        @foreach ($referrals as $referral)
                            <li class="ref-tree-item">
                                <a href="javascript:void(0);" class="ref-tree-link js-toggle-node">
                                    <div class="ref-tree-info">
                                        <img src="{{ asset($referral->referredUser->avatar_alt) }}"
                                             alt="Avatar" class="ref-tree-img">
                                        <div class="ref-tree-details">
                                            <strong>{{ $referral->referredUser->name ?? 'Unknown' }}
                                                ({{ $referral->referredUser->username }})</strong>
                                            <span>{{ __('Referrals : :count',
                                                ['count' => $referral->childReferrals->count()]) }}</span>
                                        </div>
                                    </div>
                                    @if($referral->childReferrals->isNotEmpty())
                                        <i class="fas fa-chevron-right ref-tree-icon"></i>
                                    @endif
                                </a>

                                @if($referral->childReferrals->isNotEmpty())
                                    <ul class="ref-tree-ul">
                                        @foreach ($referral->childReferrals as $child)
                                            <li class="ref-tree-item">
                                                <a href="javascript:void(0);" class="ref-tree-link js-toggle-node">
                                                    <div class="ref-tree-info">
                                                        <img src="{{ asset($child->referredUser->avatar_alt) }}"
                                                             alt="Avatar" class="ref-tree-img">
                                                        <div class="ref-tree-details">
                                                            <strong>{{ $child->referredUser->name ?? 'Unknown' }}
                                                                ({{ $child->referredUser->username }})</strong>
                                                            <span>{{ __('Referrals : :count',
                                                                ['count' => $child->childReferrals->count()]) }}</span>
                                                        </div>
                                                    </div>
                                                    @if($child->childReferrals->isNotEmpty())
                                                        <i class="fas fa-chevron-right ref-tree-icon"></i>
                                                    @endif
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                </li>
            </ul>
        </div>
    @else
        <div class="text-center py-5">
            <x-icon name="no-referral-found" height="200"/>
            <h5 class="text-muted mt-2">{{ __('No Referral Found') }}</h5>
        </div>
    @endif
@endsection

@push('scripts')
    @include('backend.user.manage.referrals.scripts')
@endpush
