@php
    $hasChildren = $referral->childReferrals->isNotEmpty();
    // Create a unique collapse id for this referral node.
    $collapseId = 'collapse-' . $referral->id;
@endphp

<div class="accordion-item">
    <h2 class="accordion-header" id="heading-{{ $referral->id }}">
        @if($hasChildren)
            <button class="accordion-button collapsed" type="button"
                    data-coreui-toggle="collapse" data-coreui-target="#{{ $collapseId }}"
                    aria-expanded="false" aria-controls="{{ $collapseId }}">
                <img src="{{ asset($referral->referredUser->avatar) }}" alt="Avatar" class="rounded me-2" style="width:35px; height:35px;">
                <div>
                    <strong>{{ $referral->referredUser->name ?? 'Unknown' }} ({{ $referral->referredUser->username }})</strong>
                    <div class="small text-muted">
                        {{ __('Referrals: :count', ['count' => $referral->childReferrals->count()]) }}
                    </div>
                </div>
            </button>
        @else
            <button class="accordion-button" type="button" disabled>
                <img src="{{ asset($referral->referredUser->avatar) }}" alt="Avatar" class="rounded me-2" style="width:35px; height:35px;">
                <div>
                    <strong>{{ $referral->referredUser->name ?? 'Unknown' }} ({{ $referral->referredUser->username }})</strong>
                </div>
            </button>
        @endif
    </h2>

    @if($hasChildren)
        <div id="{{ $collapseId }}" class="accordion-collapse collapse" data-coreui-parent="#{{ $accordionParent }}">
            <div class="accordion-body p-0">
                <!-- Nested Accordion for Child Referrals -->
                <div class="accordion" id="accordion-{{ $referral->id }}">
                    @foreach($referral->childReferrals as $child)
                        @include('backend.user.manage.partials.referral_node', [
                          'referral' => $child,
                          'accordionParent' => 'accordion-' . $referral->id
                        ])
                    @endforeach
                </div>
            </div>
        </div>
    @endif
</div>
