@extends('backend.layouts.app')
@section('title', 'User Management')

@section('content')
    <div class="mb-3">
        <h4 class="fw-bold">{{ __('Manage Of :user_name', ['user_name' => $user->name]) }}</h4>
    </div>

    <div class="row g-3">
        {{-- Left Side: User Info --}}
        @include('backend.user.partials._user_info')

        {{-- Right Side: Tabs/Pills for User Management --}}
        <div class="col-12 col-md-8 col-lg-8 col-xl-8">
            <div class="card border-0 px-6 py-7">

                @include('backend.user.partials._user_manage_header')

                <div class="py-3">
                    {{-- This section will be replaced with dynamic content based on the selected tab --}}
                    @yield('user_manage_content')
                </div>
            </div>
        </div>
    </div>


    {{-- Add Balance Modal --}}
    @include('backend.user.partials._update_balance_modal')

    {{-- Notify User Modal --}}
    @include('backend.user.partials._notify_user_modal')
@endsection

@push('scripts')
    @include('backend.user.partials._user_manage_scripts')
@endpush
