@extends('backend.support_ticket.index')
@section('title', $title)

@section('support_header')
    <div class="clearfix my-3">
        <div class="fs-4 fw-semibold float-start">@yield('title')</div>
    </div>
@endsection

    
@section('support_content')
        <div class="card mt-4 border-0 ticket-container">
            <div class="card-header border-0 d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between">
                <div class="d-flex align-items-center mb-2 mb-md-0">
                <span class="badge bg-{{ $ticket->priority->badgeColor() }} text-uppercase me-2">
                    {{ $ticket->priority->label() }}
                </span>
                    <h5 class="card-title mb-0 text-secondary text-truncate">
                        {{ __('Ticket ID: :id', ['id' => $ticket->uuid ]) }}
                    </h5>
                </div>
                
                <form action="{{ route('admin.support-ticket.status-update', $ticket->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PUT')
                    <select name="ticket_status" class="form-select form-select-sm top-control-select" onchange="this.form.submit()">
                        @foreach(\App\Enums\TicketStatus::options() as $status)
                            <option value="{{ $status['value'] }}" @selected($status['value'] == $ticket->status->value)>{{ $status['label'] }}</option>
                        @endforeach
                    </select>
                </form>
            </div>
        
            <div class="p-3">
                <h5 class="fw-bold text-primary mb-1" style="max-width: 90%;">
                    {{ $ticket->title }}
                </h5>
                <p class="text-muted mb-0">
                    {!! nl2br(e($ticket->message)) !!}
                </p>
                @if($ticket->attachment)
                    <a href="{{ route('file.download', ['filePath' => $ticket->attachment]) }}" class="d-block mt-2 text-warning small text-decoration-none attachment-link">
                        <i class="fas fa-download"></i> {{ __('Download Attachment') }}
                    </a>
                @endif
            </div>
        
        @if($ticket->messages->count() > 0)
            <div class="card-body border chat-body px-3 py-3" id="chat-box">
                @foreach($ticket->messages as $message)
                    <div class="d-flex {{ $message->admin_id ? 'justify-content-end' : 'justify-content-start' }} mb-3 flex-wrap">
                        @if(!$message->admin_id)
                            <div class="me-3">
                                <img src="{{ asset($ticket->user->avatar_alt) }}" class="rounded-circle" alt="User" width="40" height="40">
                            </div>
                        @endif
                        <div class="{{ $message->admin_id ? 'bg-secondary text-light' : 'bg-light text-dark' }} message-bubble" style="max-width: 75%;">
                            <p class="mb-2 fw-medium">{!! nl2br(e($message->message)) !!}</p>
                            @if($message->attachment)
                                <a href="{{ route('file.download', ['filePath' => $message->attachment]) }}" class="d-block mt-2 text-warning small text-decoration-none attachment-link">
                                    <i class="fas fa-download"></i> {{ __('Download Attachment') }}
                                </a>
                            @endif
                            <small class="d-block mt-2 message-meta {{ $message->admin_id ? 'text-light' : 'text-muted' }}">
                                <i class="fas fa-user"></i> {{ $message->admin_id ? 'Admin' : $ticket->user->name }} |
                                <i class="fas fa-clock"></i> {{ $message->created_at->format('g:i A') }}
                            </small>
                        </div>
                        @if($message->admin_id)
                            <div class="ms-3">
                                <img src="{{ asset(auth()->user()->avatar_alt) }}" class="rounded-circle" alt="Admin" width="40" height="40">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
        
        {{-- Chat Input Footer --}}
        <div class="card-footer rounded border-0 px-3 py-4 mt-2">
            <form action="{{ route('admin.support-ticket.reply', $ticket->id) }}" method="POST" enctype="multipart/form-data"
                  class="d-flex flex-column gap-3">
                @csrf
                
                <textarea name="message" class="form-control" rows="3" placeholder="{{ __('Type your message here...') }}" required></textarea>
                
                <div id="attachment-preview" class="d-none file-preview border px-3 py-2 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center text-muted">
                        <i class="fas fa-file me-2 text-primary"></i>
                        <span id="file-name"></span>
                    </div>
                    <button type="button" class="btn btn-link text-danger btn-sm px-2" onclick="removeFile()">
                        {{ __('Remove') }}
                    </button>
                </div>
                
                <div class="d-flex justify-content-between align-items-center gap-2 btn-wrap">
                    <div class="flex-grow-1 flex-md-grow-0">
                        <input type="file" id="file-input" name="attachment" class="d-none" onchange="showFileName(this)">
                        <label for="file-input" class="btn btn-outline-primary w-100 d-flex align-items-center justify-content-center btn-custom">
                            <i class="fas fa-paperclip me-2"></i> {{ __('Attach') }}
                        </label>
                    </div>
                    <div class="flex-grow-1 flex-md-grow-0">
                        <button type="submit" class="btn btn-primary w-100 d-flex align-items-center justify-content-center btn-custom">
                            <i class="fas fa-paper-plane me-2"></i> {{ __('Send Now') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
   @include('backend.support_ticket.partials._script')
@endpush