@extends('backend.support_ticket.index')
@section('title', $title)
@section('support_header')
    <div class="clearfix my-3">
        <div class="fs-4 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection
@section('support_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive">
                <table class="table user-table align-items-center">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Title') .' | ' . __('User') }}</th>
                        <th>{{ __('Ticket ID') . ' | ' . __('Priority') }}</th>
                        <th>{{ __('Opening Time')  }}</th>
                        <th>{{ __('Category') }}</th>
                        <th>{{ __('Status') }}</th>
                        @can('support-ticket-manage')
                            <th>{{ __('Action') }}</th>
                        @endcan
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($tickets as $ticket)
                        <tr class="align-middle ">
                            <td>
                                <div class="fw-bold">{{ $ticket->title }}</div>
                                <div class="text-muted small text-info">
                                  <a href="#" class="text-decoration-none">{{ title($ticket->user->name) }}</a>
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold">
                                    {{ ucwords($ticket->uuid) }}
                                </div>
                                <div class="text-muted small">
                                    <span class="badge bg-{{ $ticket->priority->badgeColor() }} ">{{ $ticket->priority->label() }}</span>
                                </div>

                            </td>
                            <td>
                                <div class="fw-bold">{{ $ticket->created_at->format('Y-m-d H:i') }}</div>
                                <div class="text-muted small">{{ $ticket->created_at->diffForHumans() }}</div>
                            </td>
                            <td class="fw-bold">
                                {{ $ticket->category->name ?? __('Uncategorized')  }}
                            </td>
                            <td class="fw-bold text-uppercase">
                                <span class="badge bg-{{ $ticket->status->badgeColor() }} ">{{ $ticket->status->label() }}</span>
                                @if($ticket->is_resolved)
                                    <span class="badge bg-success ms-1">{{ __('Resolved') }}</span>
                                @endif
                            </td>
                            @can('support-ticket-manage')
                                <td class="fw-bold">
                                    <a href="{{ route('admin.support-ticket.show', $ticket->id) }}" class="btn btn-primary" ><x-icon name="chat" height="20"/>{{ __('Support Now') }}</a>
                                </td>
                            @endcan

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection
