@extends('backend.layouts.app')
@section('content')
    @php($supportMenu = getAdminMenuByCode('support-ticket'))
    
    {{--support Header Dynamic Content Show Here--}}
    @yield('support_header')

    <div class="card px-3 py-4 border-0">
        @if($supportMenu && isset($supportMenu['sub_menus']))
            <ul class="nav nav-pills bg-light rounded p-1">
                @foreach($supportMenu['sub_menus'] as $menu)
                    <li class="nav-item pe-0">
                        <a class="nav-link {{ isActive($menu['route'], $menu['params'] ?? []) }}"
                           href="{{ route($menu['route'], $menu['params'] ?? []) }}">
                            <x-icon name="{{ $menu['icon'] }}" height="18" width="18" class="me-1"/>
                            {{ title($menu['label']) }}
                        </a>
                    </li>
                @endforeach
            </ul>
        @endif
        <div>
            {{-- support Dynamic Content Show Here --}}
            @yield('support_content')
        </div>
    </div>
@endSection
