@include('backend.settings.site.partials.fields._level')

<div class="input-group">
    {{-- Related Field (Optional Switch) --}}
    @if(isset($field['related_field']))
        <span class="input-group-text">
            <div class="form-check form-switch m-0">
                {{-- Hidden Field to Send a Default Value --}}
                <input type="hidden" name="{{$field['related_field']}}" value="0">
                {{-- Switch Input --}}
                <input type="checkbox"
                       class="form-check-input"
                       id="enable"
                       name="{{$field['related_field']}}"
                       value="1"
                       @checked(setting($field['related_field'], false))>
                <label class="form-check-label text-success" for="enable">{{ __('Enable') }}</label>
            </div>
        </span>
    @endif
    {{-- Main Input Field --}}
    <input type="text"
           name="{{ $field['key'] }}"
           id="{{ $field['key'] }}"
           value="{{ setting($field['key'], $field['value']) }}"
           class="form-control"
           oninput="this.value = validateDouble(this.value)"
           placeholder="{{ __('Enter Rate') }}">
    {{-- Unit Display --}}
    @if(isset($field['unit']))
        <span class="input-group-text text-uppercase">{{ __($field['unit']) }}</span>
    @endif
</div>
