@php use App\Constants\RewardType; @endphp
<div class="modal fade" id="new-reward-modal" aria-hidden="true" aria-labelledby="logoutmodal" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Add New Reward') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body reward-form">
                <form action="{{ route('admin.referral.store') }}" method="post">
                    @csrf
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label class="form-label" for="rewards">{{ __('Reward Type') }}</label>
                            <select class="form-select" name="type" required>
                                <option value="" selected disabled>{{ __('Select Reward Type') }}</option>
                                @foreach(RewardType::getTypes() as $key => $type)
                                    <option value="{{ $key }}">{{ ucfirst($type) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label class="form-label" for="rewards">{{ __('Reward Percentage') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="reward"
                                       oninput="this.value = validateDouble(this.value)"
                                       aria-label="Amount (to the nearest dollar)">
                                <span class="input-group-text">%</span>
                            </div>
                            <span class="text-muted small">{{ __('Reward percentage when user :type', ['type' => '']) }}</span>
                        </div>
                    </div>
                    <div class="text-end">
                        <button class="btn btn-primary" type="submit">
                            <x-icon name="check" height="20"/> {{ __('Add New Reward') }}
                        </button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
