<form action="{{ route('admin.referral.update', $reward->id) }}" method="post">
    @csrf
    <div class="row mb-3">
        <div class="col-md-12">
            <label class="form-label" for="rewards">{{ __(':type Reward', ['type' => ucwords($reward->type)]) }}</label>
            <div class="input-group">
                <input type="text" class="form-control" name="reward" value="{{ $reward->percentage }}"
                       oninput="this.value = validateDouble(this.value)"
                       aria-label="Amount (to the nearest dollar)">
                <span class="input-group-text">%</span>
            </div>
            <span class="text-muted small">{{ __('Reward percentage when user :type', ['type' => $reward->type]) }}</span>
        </div>
    </div>
    <div class="text-end">
        <button class="btn btn-primary" type="submit">
            <x-icon name="check" height="20"/> {{ __('Update Reward') }}
        </button>
    </div>
</form>

