@extends('backend.layouts.app')
@section('title', __('Payment Gateways'))
@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">{{  __('Payment Gateways') }}</h1>
            </div>
        </div>
    </div>
    <div class="card border-0 mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped rounded ">
                    <thead class="table-light">
                    <tr class="text-muted ">
                        <th>{{ __('Logo') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Supported Currencies') }}</th>
                        <th>{{ __('Withdraw Available') }}</th>
                        <th>{{ __('Status') }}</th>
                        @can('payment-gateway-configure')
                            <th>{{ __('Action') }}</th>
                        @endcan
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($paymentGateways as $paymentGateway)
                        <tr class="align-middle">
                            <td><img src="{{ asset($paymentGateway->logo) }}" height="25" alt=""></td>
                            <td>{{ $paymentGateway->name }}</td>
                            <td>
                                <div class="avatars-stack">
                                    @foreach(array_slice($paymentGateway->currencies, 0, 4) as $currency)
                                        <span class="badge text-bg-primary"> {{ strtoupper($currency) }}</span>
                                    @endforeach
                                    @if(count($paymentGateway->currencies) > 4)
                                        <span class="badge text-bg-danger text-white">  +{{ count($paymentGateway->currencies) - 3 }}</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                @if ($paymentGateway->withdraw_available)
                                    <span class="badge bg-success">{{ __('YES') }}</span>
                                @else
                                    <span class="badge bg-danger">{{ __('NO') }}</span>
                                @endif
                            </td>
                            <td>
                                @if($paymentGateway->status)
                                    <span class="badge bg-success">{{ __('ACTIVE') }}</span>
                                @else
                                    <span class="badge bg-danger">{{ __('INACTIVE') }}</span>
                                @endif
                            </td>
                            @can('payment-gateway-configure')
                                <td>
                                    <div class="d-inline-flex">
                                        <button class="edit-modal btn btn-primary d-flex align-items-center "
                                                data-coreui-toggle="tooltip"
                                                title="{{ __('Manage Gateway Credentials and Others') }}"
                                                data-edit-url="{{ route('admin.payment.gateway.edit',$paymentGateway->id) }}">
                                            <x-icon name="manage" height="20"/>
                                            {{ __('Manage') }}
                                        </button>
                                    </div>
                                </td>
                            @endcan
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    
    @can('payment-gateway-configure')
        {{-- Edit Payment Gateway Modal --}}
        @include('backend.payment_gateway.partial._edit_payment_gateway_modal')
    @endcan
@endsection
@push('scripts')
    @can('payment-gateway-configure')
        <script>
            $(document).ready(function () {
                'use strict'
                editFormByModal('edit-payment-gateway-modal', 'edit-payment-gateway-append', false, true);
            });
        </script>
    @endcan
@endpush
