@extends('backend.layouts.app')
@section('title')
	{{ __($settings['title']) }}
@endsection
@section('content')
	<div class="py-4">
		<div class="d-flex justify-content-between w-100 flex-wrap">
			<div class="mb-3 mb-lg-0">
				<h1 class="h4">{{ __($settings['title']) }}</h1>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-12 col-xl-12">
			<div class="card card-body border-0 shadow mb-4">
				<form method="POST" action="{{ route('admin.settings.site.update', $section) }}" enctype="multipart/form-data">
					@method('PUT')
					@csrf
					<div class="row">
						@foreach($settings['elements'] as $key => $field)
							<div class="col-12 mb-3 {{ $field['class'] }}">
								@include('backend.settings.site.partials.fields.' . $field['type'], ['field' => $field])
							</div>
						@endforeach
					</div>
					<div class="col-12">
						<button type="submit" class="btn btn-info mt-3">
							<x-icon name="check" height="20"/> {{ __('Update Now') }}
						</button>
					</div>
				</form>
			</div>
		</div>
	</div>

@endsection
