<div class="modal fade" id="review-{{ $merchant->id }}" tabindex="-1" aria-labelledby="MerchantDetailsLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-fullscreen-sm-down">
        <div class="modal-content">
            {{-- Modal Header --}}
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold" id="MerchantDetailsLabel">{{ __('View Merchant Details') }}</h5>
                <button type="button" class="btn-close btn-close-white" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>

            {{-- Merchant Action Form --}}
            <form action="{{ route('admin.merchant.request-action') }}" method="post">
                @csrf
                <input type="hidden" name="merchant_id" value="{{ $merchant->id }}">

                {{-- Modal Body --}}
                <div class="modal-body">
                    {{-- Merchant Details Section --}}
                    <div class="card border mb-3">
                        <div class="card-body p-3">
                            <h6 class="fw-bold text-primary mb-3">{{ __('Detailed Merchant Profile') }}</h6>
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <span class="fw-bold">{{ __('User') }}</span>
                                <span class="text-end">{{ $merchant->user->name }}</span>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Merchant ID') }}</span>
                                <span class="text-uppercase text-end">{{ $merchant->merchant_key }}</span>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Business Name') }}</span>
                                <span class="text-end">{{ $merchant->business_name }}</span>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Website') }}</span>
                                <span class="text-end">{{ $merchant->site_url }}</span>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Currency') }}</span>
                                <span class="text-end">{{ $merchant->currency->code }}</span>
                            </div>
                            <div>
                                <span class="fw-bold">{{ __('Business Description') }}</span>
                                <p class="mb-0 text-muted text-wrap">
                                    {{ $merchant->business_description }}
                                </p>
                            </div>
                        </div>
                    </div>


                    {{-- Fee Configuration Section --}}
                    @if($merchant->status !== \App\Enums\MerchantStatus::REJECTED)
                        <div class="card border">
                            <div class="card-body p-3">
                                <label class="form-label fw-bold" for="currency_symbol">{{ __('Set Merchant Transaction Fee') }}</label>
                                <div class="input-group">
                                    <input type="text" oninput="this.value = validateDouble(this.value)"
                                           class="form-control" name="fee" aria-label="Merchant fee in percentage"
                                           value="{{ $merchant->fee }}">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    {{-- Rejection Reason Section --}}
                    <div class="card border">
                        <div class="card-body p-3">
                            <h6 class="fw-bold text-primary mb-3">{{ __('Rejection Reason (Optional)') }}</h6>
                            <textarea class="form-control" name="rejection_reason" id="rejection_reason" rows="3"
                                      placeholder="{{ __('Reason for rejection') }}"></textarea>
                        </div>
                    </div>
                </div>

                {{-- Modal Footer --}}
                @if($merchant->status !== \App\Enums\MerchantStatus::REJECTED)
                    <div class="modal-footer bg-light p-3">
                        <div class="d-flex w-100">
                            {{-- Approve or Update Button --}}
                            <button type="submit" value="approve" name="action"
                                    class="btn btn-success text-white  {{ $merchant->status === \App\Enums\MerchantStatus::PENDING ? 'w-50' : 'w-100' }} d-flex align-items-center justify-content-center me-2">
                                <i class="fa-solid fa-check me-2"></i>
                                {{ $merchant->status === \App\Enums\MerchantStatus::PENDING ? __('Approve') : __('Update') }}
                            </button>
                            
                            {{-- Reject Button: only if status is pending --}}
                            @if($merchant->status === \App\Enums\MerchantStatus::PENDING)
                                <button type="submit" value="reject" name="action"
                                        class="btn btn-danger text-white w-50 d-flex align-items-center justify-content-center">
                                    <i class="fa-solid fa-times me-2"></i> {{ __('Reject') }}
                                </button>
                            @endif
                        </div>
                    </div>
                @endif
            
            
            </form>
        </div>
    </div>
</div>

