@extends('backend.layouts.app')
@section('content')
    <div class="clearfix my-3">
        <div class="fs-3 fw-semibold float-start">
            {{ $title }}
        </div>
    </div>
    <div class="card border-0 mb-4">
        <div class="card-body">

            @include('backend.merchant.partials._filter')

            {{-- Transactions Table --}}
            <div class="table-responsive">
                <table class="table caption-top mb-0">
                    <thead class="table-light fw-semibold text-nowrap">
                    <tr class="align-middle">
                        <th>{{ __('Merchant Info') }}</th>
                        <th>{{ __('User | Merchant ID') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                        @can('merchant-manage')
                             <th>{{ __('Action') }}</th>
                        @endcan
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($merchants as $merchant)
                        @php
                            $statusColor = $merchant->status->color();
                        @endphp
                        <tr class="align-middle">
                            <td>
                                <div class="d-flex align-items-center">
                                    <img class="rounded-circle shadow-sm me-2" width="36" height="36"
                                         src="{{ asset($merchant->business_logo) }}" alt="User Avatar">
                                    <div>
                                        <div class="text-nowrap">{{ $merchant->business_name }}</div>
                                        <div class="small text-muted ">{{ $merchant->site_url }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="text-primary-emphasis fw-bold">
                                    <a href="{{ route('admin.user.manage', $merchant->user->username) }}" class="text-decoration-none">{{ $merchant->user->name }}</a>
                                </div>
                                <div class="small text-muted">{{ $merchant->merchant_key }}</div>
                            </td>
                                <td class="text-nowrap text-uppercase">
                            <span class="badge bg-{{  $statusColor }}">
                                {{ $merchant->status }}
                            </span>
                                </td>
                            <td>
                                <div>{{ $merchant->created_at->format('Y-m-d H:i') }}</div>
                                <div class="small text-muted">{{ $merchant->created_at->diffForHumans() }}</div>
                            </td>
                            @can('merchant-manage')
                                <td>
                                    <button type="button" class="btn btn-primary" data-coreui-toggle="modal"
                                            data-coreui-target="#review-{{ $merchant->id }}">
                                        <i class="fa-duotone fa-arrow-right-from-bracket"></i>
                                        
                                        
                                        {{ $merchant->status == \App\Enums\MerchantStatus::PENDING ? __('Review Request') : __('Details View') }}
                                    </button>
                                    
                                    @include('backend.merchant.partials._review_modal')
                                </td>
                            @endcan
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center text-muted py-5">
                                {{ __('No Merchant found.') }}
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-end mt-3">
                {{ $merchants->links() }}
            </div>
        
        </div>
    </div>
@endSection
