
@php
    use App\Enums\NotificationActionType;
	$notificationCount = $notifications->count();
@endphp
<a class="nav-link position-relative" data-coreui-toggle="dropdown" href="#" role="button">
    <x-icon name="cil-bell" class="icon icon-lg"/>
    @if($notifications->count() > 0)
        <span class="position-absolute top-1 start-100 translate-middle badge rounded-pill bg-danger">
            {{ $notifications->count() > 99 ? '99+' : $notifications->count() }}
        </span>
    @endif
</a>

<div class="dropdown-menu dropdown-menu-end p-0 shadow notification-dropdown" data-coreui-display="static">
    {{-- Header --}}
    <div class="dropdown-header d-flex justify-content-between align-items-center px-4 py-3 border-bottom">
        <span class="notification-header">
            {{ __('You have :count new notifications', ['count' => $notifications->count()]) }}
        </span>
    </div>
    
    
    @if($notifications->isEmpty())
        <div class="text-center p-4 text-muted small">
            <i class="bi bi-inbox fs-2 opacity-50 d-block mb-2"></i>
            {{ __('No new notifications') }}
        </div>
    @else
        {{-- Scrollable Notification List --}}
        <div class="scrollable-notification-list">
            @foreach($notifications->take(10) as $notification)
                @php
                    $data   = $notification->data;
                    $sender = $data['sender'] ?? null;
                @endphp
                
                <a class="dropdown-item notification-dropdown-item read-notification"
                   href="{{ $data['action_link'] ?? 'javascript:void(0)' }}"
                   data-id="{{ $notification->id }}">
                    
                    <div class="d-flex gap-2 align-items-start">
                        {{-- Avatar --}}
                        <div class="notification-avatar" data-coreui-toggle="tooltip"
                             data-coreui-placement="top"
                             title="{{ $sender['name'] }}" >
                            <img src="{{ asset($sender['avatar']) }}"
                                 alt="Avatar"
                                 class="notification-avatar-img">
                        </div>
                        
                        {{-- Content --}}
                        <div class="notification-content">
                            <div class="d-flex justify-content-between align-items-start">
                                <span class="notification-title">{{ $data['title'] }}</span>
                                <small class="notification-time" data-coreui-toggle="tooltip" data-coreui-placement="top" title="{{ $notification->created_at->format('Y-m-d H:i') }}">{{ $notification->created_at->diffForHumans() }}</small>
                            </div>
                            <div class="notification-message">{{ $data['message'] }}</div>
                        </div>
                    
                    </div>
                </a>
            @endforeach
        </div>
    @endif
    
    <div class="px-3 py-2 border-top bg-white">
        <div class="d-flex flex-wrap flex-md-nowrap gap-2 w-100">
            
            @unless($notifications->isEmpty())
                <a href="{{ route('admin.notifications.markAllAsRead') }}"
                   class="btn  btn-success flex-fill text-nowrap d-flex align-items-center justify-content-center text-white">
                    <i class="fa fa-check-double me-1"></i>
                    {{ __('Mark all as read') }}
                </a>
            @endunless
            
            <a href="{{ route('admin.notifications.index') }}"
               class="btn  btn-primary flex-fill text-nowrap d-flex align-items-center justify-content-center">
                <i class="fa fa-eye me-1"></i>
                {{ __('View all') }}
            </a>
        </div>
    </div>
    
</div>


@push('scripts')
    <script>
        'use strict';
        // Attach click event to mark notification as read
        $(document).on('click', '.read-notification', function () {
            'use strict';

            const notificationId = $(this).data('id');
            const url = "{{ route('admin.notifications.markAsRead', ':id') }}".replace(':id', notificationId);

            // Make AJAX request to mark notification as read
            $.ajax({
                url: url,
                type: 'get',
                data: {
                    _token: '{{ csrf_token() }}' // Ensure CSRF token is included
                },
                success: function (response) {
                    const notificationUrl = '{{ route('admin.notifications.recent') }}';
                    $.get(notificationUrl, function (response) {
                        $('#append-new-admin-notification').html(response); // Update notifications
                    });
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.error('Error marking notification as read:', textStatus, errorThrown);
                    // Optionally display an error message to the user
                }
            });
        });
    </script>
@endpush
