<div class="row g-2 align-items-center mb-2 field-item">
    {{-- Field Label --}}
    <div class="col-12 col-md-4">
        <input type="text" name="fields[{{ $key }}][label]" class="form-control"
               value="{{ $field['label'] ?? '' }}"
               placeholder="{{ __('Field Name') }}" required>
    </div>

    {{-- Field Type --}}
    <div class="col-12 col-md-3">
        <select name="fields[{{ $key }}][type]" class="form-select" required>
            <option value="text" {{ (isset($field['type']) && $field['type'] == 'text') ? 'selected' : '' }}>{{ __('Input Text') }}</option>
            <option value="file" {{ (isset($field['type']) && $field['type'] == 'file') ? 'selected' : '' }}>{{ __('File') }}</option>
            <option value="number" {{ (isset($field['type']) && $field['type'] == 'number') ? 'selected' : '' }}>{{ __('Number') }}</option>
        </select>
    </div>

    {{-- Required Option --}}
    <div class="col-12 col-md-3">
        <select name="fields[{{ $key }}][required]" class="form-select" required>
            <option value="true" {{ (isset($field['required']) && $field['required'] == 'true') ? 'selected' : '' }}>{{ __('Required') }}</option>
            <option value="false" {{ (isset($field['required']) && $field['required'] == 'false') ? 'selected' : '' }}>{{ __('Optional') }}</option>
        </select>
    </div>

    {{-- Remove Button --}}
    <div class="col-12 col-md-2 text-end">
        <button type="button" class="btn btn-danger remove-field w-100 text-white">
            <i class="fa fa-trash"></i> <span class="d-none d-md-inline">{{ __('Delete') }}</span>
        </button>
    </div>
</div>
