@php use App\Enums\UserRole; @endphp
<div class="modal fade" id="createTemplateModal" tabindex="-1" aria-labelledby="createTemplateLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content kyc-template-content">
            <div class="modal-header">
                <h5 id="createTemplateLabel" class="modal-title">{{ __('Add New KYC Template') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.kyc.template.store') }}" method="POST" id="create-template-form">
                @csrf

                <div class="modal-body">
                    {{-- Title --}}
                    <div class="mb-3">
                        <label for="title" class="form-label">{{ __('Title') }}</label>
                        <input type="text" name="title" id="title" class="form-control"  value="{{ old('title') }}"
                               required>
                    </div>

                    {{-- Description --}}
                    <div class="mb-3">
                        <label for="description" class="form-label">{{ __('Description') }}</label>
                        <textarea name="description" id="description" class="form-control"
                                  rows="3">{{ old('description') }}</textarea>
                    </div>

                    {{-- Applicable To (Multi-Select / Checkboxes) --}}
                    <div class="mb-3">
                        <label class="form-label d-block">{{ __('Applicable To') }}</label>
                        <div class="d-flex flex-wrap gap-2">
                            @foreach(UserRole::cases() as $role)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="applicable_to[]"
                                           value="{{ $role->value }}" id="role_{{ $role->value }}">
                                    <label class="form-check-label"
                                           for="role_{{ $role->value }}">{{ $role->title() }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    {{-- Dynamic Fields Section --}}
                    <div class="mb-3">
                        <label class="form-label">{{ __('Fields') }}</label>
                        <div id="fields-container" class="fields-container">
                            @include('backend.kyc.template.partials._fields', ['key' => 0, 'field' => []])
                        </div>
                        <button type="button" class="btn btn-primary mt-2 add-new-field" id="add-new-field">
                            <i class="fa fa-plus"></i> {{ __('Add New Field') }}
                        </button>
                    </div>

                    {{-- Status --}}
                    <div class="mb-3">
                        <label for="status" class="form-label">{{ __('Status') }}</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input coevs-switch" type="hidden" name="status" value="0">
                            <input class="form-check-input coevs-switch" type="checkbox" name="status" value="1">
                        </div>
                    </div>
                </div>

                {{-- Modal Footer with Submit Button --}}
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary ">
                        <x-icon name="check" height="20" width="20"/> {{ __('Create Template') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

