@php use App\Enums\UserRole; @endphp
@extends('backend.layouts.app')
@section('title', __('KYC Templates'))

@section('content')
    <div class="clearfix my-3">
        <div class="fs-3 fw-semibold float-start">{{ __('KYC Templates') }}</div>
        @can('kyc-template-manage')
            <button class="btn btn-primary float-end" data-coreui-toggle="modal" data-coreui-target="#createTemplateModal">
                <x-icon name="add" class="icon"/> {{ __('Add New') }}
            </button>
        @endcan
    </div>

    <div class="card border-0 mb-4">
        <div class="card-body">
            <div class="table-responsive rounded">
                <table class="table mb-0 caption-top align-middle">
                    <thead>
                    <tr>
                        <th>{{ __('Title|Description') }}</th>
                        <th>{{ __('Applicable To') }}</th>
                        <th>{{ __('Status') }}</th>
                        @can('kyc-template-manage')
                            <th class="text-end">{{ __('Actions') }}</th>
                        @endcan
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($templates as $template)
                        <tr>
                            <td>
                                <div class="text-nowrap">  {{ $template->title }} </div>
                                <div class="small text-body-secondary text-nowrap">{{ $template->description }}</div>
                            </td>
                            <td>
                                @if(is_array($template->applicable_to))
                                    @foreach($template->applicable_to as $role)
                                        <span class="badge bg-{{ UserRole::from($role)->color() }} text-uppercase">{{ UserRole::from($role)->title() }}</span>
                                    @endforeach
                                @endif
                            </td>

                            <td>
                                <span class="badge text-uppercase {{ $template->status ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $template->status ? __('Active') : __('Inactive') }}
                                </span>
                            </td>
                            
                            @can('kyc-template-manage')
                                <td class="text-end">
                                    {{-- Edit Button --}}
                                    <button class="btn btn-primary edit-modal"
                                            data-edit-url="{{ route('admin.kyc.template.edit', $template->id) }}">
                                        <i class="fa fa-edit"></i> {{ __('Edit') }}
                                    </button>
                                    {{-- Delete Button --}}
    
                                    {{-- Delete Button --}}
                                    <button class="btn btn-danger delete text-white"
                                            data-url="{{ route('admin.kyc.template.destroy', $template->id) }}">
                                        <i class="fa fa-trash "></i> {{ __('Delete') }}
                                    </button>
                                </td>
                            @endcan
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">{{ __('No KYC Templates found.') }}</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    @can('kyc-template-manage')
        {{--  Create Template Modal --}}
        @include('backend.kyc.template.partials._create_template_modal')
    
        {{--  Edit Template Modal --}}
        @include('backend.kyc.template.partials._edit_template_modal')
    @endcan

@endsection
@push('scripts')
    @can('kyc-template-manage')
        @include('backend.kyc.template.partials._script')
    @endcan
@endpush
