<form action="{{ route('admin.kyc.template.update', $template->id) }}" method="POST" id="edit-template-form">
    @csrf
    @method('PUT')
    <div class="modal-body">
        {{-- Title --}}
        <div class="mb-3">
            <label for="title_edit" class="form-label">{{ __('Title') }}</label>
            <input type="text" name="title" id="title_edit" class="form-control"
                   value="{{ old('title', $template->title) }}" required>
        </div>

        {{-- Description --}}
        <div class="mb-3">
            <label for="desc_edit" class="form-label">{{ __('Description') }}</label>
            <textarea name="description" id="desc_edit" rows="2" class="form-control">{{ old('description', $template->description) }}</textarea>
        </div>

        {{-- Applicable To --}}
        <div class="mb-3">
            <label class="form-label d-block">{{ __('Applicable To') }}</label>
            <div class="d-flex gap-3 flex-wrap">
                @foreach(\App\Enums\UserRole::cases() as $role)
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox"
                               name="applicable_to[]" value="{{ $role->value }}"
                               id="role_edit_{{ $role->value }}"
                                {{ in_array($role->value, old('applicable_to', $template->applicable_to ?? [])) ? 'checked' : '' }}>
                        <label class="form-check-label" for="role_edit_{{ $role->value }}">
                            {{ $role->title() }}
                        </label>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Dynamic Fields Section --}}
        <div class="mb-3">
            <label class="form-label">{{ __('Fields') }}</label>
            <div id="edit-fields-container" class="fields-container">
                @foreach($template->fields ?? [] as $index => $field)
                    @include('backend.kyc.template.partials._fields', ['key' => $index, 'field' => $field])
                @endforeach
            </div>
            <button type="button" class="btn btn-primary mt-2 add-new-field" id="edit-add-new-field">
                <i class="fa fa-plus"></i> {{ __('Add New Field') }}
            </button>
        </div>

        {{-- Status --}}
        <div class="mb-3">
            <label for="status" class="form-label">{{ __('Status') }}</label>
            <div class="form-check form-switch">
                <input type="hidden" name="status" value="0">
                <input class="form-check-input coevs-switch" type="checkbox" name="status" value="1"{{ $template->status ? 'checked' : '' }}>
            </div>
        </div>

    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-coreui-dismiss="modal">{{ __('Close') }}</button>
        <button type="submit" class="btn btn-primary">
            <x-icon name="check" :height="20"/>
            {{ __('Update Template') }}
        </button>
    </div>
</form>
