<div class="modal fade" id="review-{{ $submission->id }}" tabindex="-1" aria-labelledby="kycModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            {{-- Modal Header --}}
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold" id="kycModalLabel">{{ __('KYC Request Details') }}</h5>
                <button type="button" class="btn-close btn-close-white" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>

            <form action="{{ route('admin.kyc.request-action') }}" method="post">
                @csrf
                <input type="hidden" name="submission_id" value="{{ $submission->id }}">
                {{-- Modal Body --}}
                <div class="modal-body">
                    {{-- Submitted Information --}}
                    <div class="card border">
                        <div class="card-body p-2">
                            <h6 class="fw-bold text-primary mb-0">{{ __(':kyc_type Submitted Information', ['kyc_type' => $submission->kycTemplate->title]) }}</h6>
                            <p class="mb-3 fw-bold text-muted small">{{ __('Note:') .' '. $submission->notes ?? 'N\A' }}</p>

                            @foreach($submission->submission_data as $fieldName => $value)
                                <div class="mb-3">
                                    <p class="fw-bold mb-1">{{ ucwords($fieldName) }}</p>
                                    @if(is_string($value) && Str::startsWith($value, 'files/'))
                                        @if(preg_match('/\.(jpg|jpeg|png|gif)$/i', $value))
                                            <img src="{{ asset($value) }}" alt="{{ $fieldName }}" class="img-fluid rounded border">
                                        @else
                                            <a href="{{ asset($value) }}" download class="btn btn-outline-primary">
                                                <i class="fa-solid fa-download me-1"></i> {{ __('Download File') }}
                                            </a>
                                        @endif
                                    @else
                                        <p>{{ $value }}</p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                    
                    @if(empty($action) || $action !== 'view')
                    {{-- Remarks Section --}}
                        <div class="card border">
                            <div class="card-body p-2">
                                <h6 class="fw-bold text-primary mb-3">{{ __('Add Your Remarks (Optional)') }}</h6>
                                <textarea class="form-control" name="remarks" id="remarks" rows="3"
                                          placeholder="{{ __('Write your remarks here...') }}"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    {{-- Modal Footer --}}
                    <div class="modal-footer bg-light p-2">
                        <div class="d-flex w-100">
                            <button type="submit" value="approve" name="action"
                                    class="btn btn-success text-white w-50 d-flex align-items-center justify-content-center me-2">
                                <i class="fa-solid fa-check me-2"></i> {{ __('Approve KYC') }}
                            </button>
                            <button type="submit" value="reject" name="action"
                                    class="btn btn-danger text-white w-50 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-times me-2"></i> {{ __('Reject KYC') }}
                            </button>
                        </div>
                    </div>
                @endif


            </form>

        </div>
    </div>
</div>
