<div class="mb-4">
    <div class="field-remove-row row">
        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 mb-2 mb-xl-0">
            <input
                    name="fields[{{ $key }}][name]"
                    class="form-control"
                    type="text"
                    value="{{ old('fields.'.$key.'.name', $field['name'] ?? '') }}"
                    required
                    placeholder="Field Name">
        </div>

        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 mb-2 mb-xl-0">
            <select name="fields[{{ $key }}][type]" class="form-select">
                <option value="text" @selected(old('fields.'.$key.'.type', $field['type'] ?? '') == 'text')>
                    {{ __('Input Text') }}
                </option>
                <option value="textarea" @selected(old('fields.'.$key.'.type', $field['type'] ?? '') == 'textarea')>
                    {{ __('Textarea') }}
                </option>
                <option value="file" @selected(old('fields.'.$key.'.type', $field['type'] ?? '') == 'file')>
                    {{ __('File') }}
                </option>
            </select>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-2">
            <select name="fields[{{ $key }}][validation]" class="form-select">
                <option value="required" @selected(old('fields.'.$key.'.validation', $field['validation'] ?? '') == 'required')>
                    {{ __('Required') }}
                </option>
                <option value="nullable" @selected(old('fields.'.$key.'.validation', $field['validation'] ?? '') == 'nullable')>
                    {{ __('Optional') }}
                </option>
            </select>
        </div>

        <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6">
            <button class="btn btn-danger text-white delete_field" type="button">
                <x-icon name="cil-trash" height="20"/>
            </button>
        </div>
    </div>
</div>

