@php use App\Constants\FixPctType; @endphp
<form action="{{ route('admin.deposit.method.update', $paymentMethod->id) }}" method="post"
      enctype="multipart/form-data">
    @method('PUT')
    @csrf
    <input type="hidden" name="type" value="{{ $paymentMethod->type }}">
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="icon">{{ __('Logo') }}</label>
            <x-img name="logo" old="{{ $paymentMethod->logo_alt }}" :ref="'coevs-payment-method-logo'"/>
        </div>
    </div>
    @if($paymentMethod->type === App\Enums\MethodType::AUTOMATIC)
        <div class="row mb-3">
            <div class="col-lg-6 col-md-6 col-12">
                <label class="form-label" for="role">{{ __('Payment Gateway') }}</label>
                <select class="form-select" id="select-payment-gateway" name="payment_gateway_id" required>
                    <option selected disabled>{{ __('Select Payment Gateway') }}</option>
                    @foreach($paymentGateways as $gateway)
                        <option value="{{ $gateway->id }}" @selected($paymentMethod->payment_gateway_id === $gateway->id)>{{ $gateway->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                <label class="form-label" for="currency">{{ __('Supported Currency') }}</label>
                <select class="form-select" id="currency-list" name="currency" required>
                    @foreach($paymentMethod->paymentGateway->currencies as $paymentCurrency)
                        <option value="{{ $paymentCurrency }}" @selected($paymentMethod->currency === $paymentCurrency)>{{ $paymentCurrency }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    @endif
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="name">{{ __('Name') }}</label>
            <input class="form-control" type="text" value="{{ $paymentMethod->name }}" name="name" placeholder="Name"
                   required>
        </div>
        <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
            <label class="form-label" for="currency_symbol">{{ __('Currency Symbol') }}</label>
            <input class="form-control" type="text" name="currency_symbol" value="{{ $paymentMethod->currency_symbol }}"
                   id="currency-symbol" placeholder="Ex: $, BTC"
                   required>
        </div>
    </div>

    @if($paymentMethod->type == App\Enums\MethodType::MANUAL)
        <div class="row mb-3">
            <div class="col-lg-6 col-md-6 col-12">
                <label class="form-label" for="code">{{ __('Method Code') }}</label>
                <input class="form-control" type="text" name="method_code" value="{{ $paymentMethod->method_code }}"
                       placeholder="Ex: paypal-usd, custom-name-btc" required>
            </div>

            <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                <label class="form-label" for="currency">{{ __('Currency') }}</label>
                <input class="form-control" type="text" name="currency" id="custom_currency"
                       value="{{ $paymentMethod->currency }}"
                       placeholder="Ex: USD, BTC,etc.."
                       required>
            </div>
        </div>
    @endif
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="conversion_rate">{{ __('Conversion Rate:') }}</label>
            @if($paymentMethod->type == App\Enums\MethodType::AUTOMATIC)
                <a class="badge text-bg-secondary text-decoration-none"
                   href="{{ route('admin.settings.plugin_type','exchange_rate') }}"> {{ __('Manage Exchange') }}</a>
            @endif

            <div class="input-group">
                <span class="input-group-text">1 {{ siteCurrency() }} =</span>
                <input type="text" oninput="this.value = validateDouble(this.value)"
                       name="conversion_rate" value="{{ $paymentMethod->conversion_rate }}" id="conversion_rate"
                       class="form-control"
                       aria-label="Amount (to the nearest dollar)">
                @if($paymentMethod->type == App\Enums\MethodType::AUTOMATIC)
                    <span class="input-group-text">
                        <div class="form-check form-switch">
                          <input type="hidden" name="conversion_rate_live" value="0">
                          <input class="form-check-input" id="conversion_rate_live" type="checkbox"
                                 @checked($paymentMethod->conversion_rate_live)
                                 name="conversion_rate_live" value="1">
                          <label class="form-check-label text-danger" for="conversion_rate_live">
                            {{ __('Live') }}
                          </label>
                        </div>
                    </span>
                @endif
                <span class="input-group-text" id="currency-selected">{{ $paymentMethod->currency }}</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
            <label class="form-label" for="currency_symbol">{{ __('Charge:') }}</label>
            <div class="input-group evs-input-group">
                <input class="form-control" type="text"
                       oninput="this.value = validateDouble(this.value)"
                       name="charge" value="{{ $paymentMethod->charge }}" placeholder="Charge" required>
                <select name="charge_type" class="form-select input-group-select">
                    @foreach(FixPctType::getTypeWithSymbol() as $key => $value)
                        <option value="{{ $key }}" @selected($key == $paymentMethod->charge_type)>{{ $value }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="currency_symbol">{{ __('Minimum Deposit:') }}</label>
            <div class="input-group">
                <input type="text" class="form-control" name="min_deposit" value="{{ $paymentMethod->min_deposit }}"
                       oninput="this.value = validateDouble(this.value)"
                       aria-label="Amount (to the nearest dollar)">
                <span class="input-group-text">{{ siteCurrency() }}</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
            <label class="form-label" for="currency_symbol">{{ __('Maximum Deposit:') }}</label>
            <div class="input-group">
                <input type="text" class="form-control" name="max_deposit" value="{{ $paymentMethod->max_deposit }}"
                       oninput="this.value = validateDouble(this.value)"
                       aria-label="Amount (to the nearest dollar)">
                <span class="input-group-text">{{ siteCurrency() }}</span>
            </div>
        </div>
    </div>

    @if($paymentMethod->type == App\Enums\MethodType::MANUAL)
        <div class="mb-3 mt-4">
            <div class="col-xl-3 mb-3">
                <a href="javascript:void(0)" id="add-new-field"
                   class="btn btn-primary add-new-field">
                    <x-icon name="add" height="20"/>{{ __('Add New Field') }}</a>
            </div>
            <div class="append-new-field-edit mb-3">
                @foreach($paymentMethod->fields as $key => $value)
                    @include('backend.deposit.method.partials._method_append_form_field', ['key' => $key, 'field' => $value])
                @endforeach
            </div>
            <div class="col-xl-12">
                <div class="site-input-groups fw-normal">
                    <label for="" class="form-label">{{ __('Receive Payment Details:') }}</label>
                    <div class="site-editor">
                        <textarea class="summernote form-control"
                                  name="receive_payment_details">{!! $paymentMethod->receive_payment_details !!}</textarea>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="row mb-3">
        <div class="col-lg-4 col-md-4 col-4">
            <label class="form-label" for="status">{{ __('Status') }}</label>
            <div class="form-check form-switch">
                <input class="form-check-input coevs-switch" type="checkbox" name="status"
                       @checked($paymentMethod->status) value="1">
            </div>
        </div>
    </div>
    <div class="text-end">
        <button class="btn btn-primary" type="submit">
            <x-icon name="check" height="20"/> {{ __('Update Payment Method') }}
        </button>
    </div>
</form>

