<script>
    $(document).ready(function () {
        'use strict';

        const $modalForm = $('.currency-modal-form');
        const currencies = @json(getJsonData('currencies'));

        // Populate currency options based on selected type
        function populateCurrencyOptions(currencyType) {
            const selectedCurrencies = currencies[currencyType] || [];

            // Clear and populate currency dropdown
            $modalForm.find('#site_currency').empty().append(
                $('<option>', { disabled: true, selected: true }).text('{{ __('Select Currency') }}')
            );

            selectedCurrencies.forEach(currency => {
                $modalForm.find('#site_currency').append(
                    $('<option>', { value: currency.name }).text(currency.name)
                );
            });
        }

        // Update currency details based on the selected currency
        function updateCurrencyDetails(selectedCurrency) {
            const allCurrencies = [...currencies['fiat'], ...currencies['crypto']];
            const currencyData = allCurrencies.find(c => c.name === selectedCurrency);

            if (currencyData) {
                $modalForm.find('#currency_code').val(currencyData.code);
                $modalForm.find('#currency_symbol').val(currencyData.symbol);
                $modalForm.find('#currency-selected').text(currencyData.code);
            }
        }

        // Event handler for currency type change
        $modalForm.on('change', '#site_currency_type', function () {
            const currencyType = $(this).val();
            populateCurrencyOptions(currencyType);
        });

        // Event handler for currency selection change
        $modalForm.on('change', '#site_currency', function () {
            const selectedCurrency = $(this).val();
            updateCurrencyDetails(selectedCurrency);
        });

        // Event handler for currency code keyup
        $modalForm.on('keyup', '#currency_code', function () {
            const selectedCurrency = $(this).val();
            $modalForm.find('#currency-selected').text(selectedCurrency);
        });

        // Call to edit form modal function
        // This function is likely customized, so ensure any specific requirements it has are met
        editFormByModal('edit_currency_modal', 'edit_currency_append', true, true);
    });


</script>
