@php use App\Constants\CurrencyType; @endphp
@php use App\Constants\CurrencyRole; @endphp
@php use App\Constants\FixPctType; @endphp
<div class="modal fade currency-modal-form" id="new_currency_modal" aria-hidden="true" aria-labelledby="logoutmodal"
     tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Add New Currency') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('admin.currency.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row g-3">
                        {{-- Flag Row --}}
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Flag') }}</label>
                            <x-img name="flag"/>
                        </div>

                        <div class="w-100"></div>

                        {{-- Currency Type and Name --}}
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Currency Type') }}</label>
                            <select name="type" class="form-select" required id="site_currency_type">
                                <option selected disabled>{{ __('Select Currency Type') }}</option>
                                @foreach(CurrencyType::getTypes() as $type)
                                <option value="{{ $type }}">{{ ucfirst($type) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Currency Name') }}</label>
                            <select name="name" class="form-select" id="site_currency">
                                <option selected disabled>{{ __('First Select Currency Type') }}</option>
                            </select>
                        </div>

                        {{-- Code and Symbol --}}
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Code') }}</label>
                            <input type="text" name="code" value="{{ old('code') }}" id="currency_code"
                                   class="form-control" placeholder="{{ __('Code') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Symbol') }}</label>
                            <input type="text" name="symbol" value="{{ old('symbol') }}" id="currency_symbol"
                                   class="form-control" placeholder="{{ __('Symbol') }}" required>
                        </div>

                        {{-- Conversion Rate with Live Option --}}
                        <div class="col-lg-6 col-md-12">
                            <label class="form-label">{{ __('Conversion Rate') }}</label>
                            <a class="badge bg-secondary text-decoration-none"
                               href="{{ route('admin.settings.plugin_type','exchange_rate') }}">{{ __('Manage Exchange') }}</a>
                            <div class="input-group">
                                <span class="input-group-text">1 {{ siteCurrency() }} =</span>
                                <input type="text" oninput="this.value = validateDouble(this.value)"
                                       name="exchange_rate" id="conversion_rate" class="form-control">
                                <span class="input-group-text">
                                    <div class="form-check form-switch">
                                        <input type="hidden" name="rate_live" value="0">
                                        <input class="form-check-input" id="rate_live" type="checkbox" name="rate_live"
                                               value="1">
                                        <label class="form-check-label text-danger"
                                               for="rate_live">{{ __('Live') }}</label>
                                    </div>
                                </span>
                                <span class="input-group-text" id="currency-selected"></span>
                            </div>
                        </div>

                        {{-- Default and Status Toggles --}}

                        <div class="col-md-6">
                            <label class="form-label" for="default">
                                {{ __('Auto Wallet') }}
                                <span data-coreui-toggle="tooltip" data-coreui-placement="top"
                                      title="{{ __('If enabled, when a user registers, a wallet will be created automatically for this currency.') }}">
                                    <x-icon name="info" height="18"/>
                                </span>
                            </label>
                            <div class="form-check form-switch p-2 border rounded d-flex align-items-center">
                                <label class="form-check-label flex-grow-1" for="default">{{ __('Enable') }}</label>
                                <input class="form-check-input me-2" type="checkbox" role="switch" name="auto_wallet"
                                       value="1"
                                       id="default">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label" for="default">{{ __('Default') }}</label>
                            <div class="form-check form-switch p-2 border rounded d-flex align-items-center">
                                <label class="form-check-label flex-grow-1" for="default">{{ __('Enable') }}</label>
                                <input class="form-check-input me-2" type="checkbox" role="switch" name="default"
                                       value="1"
                                       id="default">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="default">{{ __('Status') }}</label>
                            <div class="form-check form-switch p-2 border rounded d-flex align-items-center">
                                <label class="form-check-label flex-grow-1" for="status">{{ __('Enable') }}</label>
                                <input class="form-check-input me-2" type="checkbox" role="switch" name="status"
                                       value="1" id="status">
                            </div>
                        </div>


                        {{-- Roles Accordion --}}
                        <div class="col-12">
                            <p class="lead text-muted fw-bold mt-2">
                                #{{ __('Role with Fee and Limit Management') }}
                            </p>
                            <div class="accordion" id="accordionExample">
                                @foreach(CurrencyRole::getRoles() as $role)
                                <input type="hidden" name="roles[{{ $role }}][role_name]" value="{{ $role }}">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingRole{{ $role }}">
                                        <button class="accordion-button collapsed" type="button"
                                                data-coreui-toggle="collapse"
                                                data-coreui-target="#collapseRole{{ $role }}"
                                                aria-expanded="false" aria-controls="collapseRole{{ $role }}">
                                            <x-icon :name="$role" height="20" width="20" class="me-2"/>
                                            {{ Str::upper($role) }}
                                        </button>
                                    </h2>
                                    <div id="collapseRole{{ $role }}" class="accordion-collapse collapse"
                                         aria-labelledby="headingRole{{ $role }}"
                                         data-coreui-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                @if($role !== CurrencyRole::WITHDRAW)
                                                {{-- Fee --}}
                                                <div class="col-md-4">
                                                    <label class="form-label">{{ __('Fee') }}</label>
                                                    <div class="input-group evs-input-group">
                                                        <input type="text" class="form-control"
                                                               name="roles[{{ $role }}][fee]"
                                                               value="{{ old('roles.' . $role . '.fee', $currency->roles->where('role_name', $role)->first()->fee ?? '') }}"
                                                               placeholder="{{ __('Fee') }}"
                                                               oninput="this.value = validateDouble(this.value)">
                                                        <select name="roles[{{ $role }}][fee_type]"
                                                                class="form-select input-group-select">
                                                            @foreach(FixPctType::getTypeWithSymbol() as $key => $value)
                                                            <option value="{{ $key }}" @selected(old('roles.' . $role . '.fee_type') == $key)>
                                                                {{ $value }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                {{-- Min Limit --}}
                                                <div class="col-md-4">
                                                    <label class="form-label">{{ __('Minimum Amount') }}</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control"
                                                               name="roles[{{ $role }}][min_limit]"
                                                               value="{{ old('roles.' . $role . '.min_limit',10) }}"
                                                               oninput="this.value = validateDouble(this.value)">
                                                        <span class="input-group-text">{{ siteCurrency() }}</span>
                                                    </div>
                                                </div>
                                                {{-- Max Limit --}}
                                                <div class="col-md-4">
                                                    <label class="form-label">{{ __('Maximum Amount') }}</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control"
                                                               name="roles[{{ $role }}][max_limit]"
                                                               value="{{ old('roles.' . $role . '.max_limit',1000) }}"
                                                               oninput="this.value = validateDouble(this.value)">
                                                        <span class="input-group-text">{{ siteCurrency() }}</span>
                                                    </div>
                                                </div>
                                                @else
                                                <span class="text-muted">{{ __('Withdrawal fee & limit only applicable for withdraw payment method') }}</span>
                                                @endif

                                                {{-- Status Toggle --}}
                                                <div class="col-md-6">
                                                    <div class="form-check form-switch">
                                                        <input type="hidden" name="roles[{{ $role }}][status]"
                                                               value="0">
                                                        <input class="form-check-input" type="checkbox"
                                                               role="switch"
                                                               name="roles[{{ $role }}][status]" value="1"
                                                               id="role_status_{{ $role }}" @checked(old('roles.' . $role . '.status'))>
                                                        <label class="form-check-label"
                                                               for="role_status_{{ $role }}">{{ __('Status') }}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                    <div class="text-end mt-3">
                        <button class="btn btn-primary" type="submit">
                            <x-icon name="check" height="20"/> {{ __('Create Now') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
