@extends('backend.layouts.app')
@section('title', __('Activity History'))
@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <h1 class="h4 mb-3">{{ __('Activity History') }}</h1>
        </div>
    </div>

    <div class="card border-0 mb-4">
        <div class="card-body">
            {{-- Filters --}}
            <div class="d-flex justify-content-end mb-3">
                <form action="{{ route('admin.activity-log') }}" method="GET" class="row g-2 g-md-3">
                    {{-- Date Range Picker --}}
                    <div class="col-md-6 col-xl-auto">
                        <div class="input-group">
                            <input type="hidden" name="daterange" value="{{ request('daterange') }}">
                            <div id="reportrange"
                                 class="form-control d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center gap-2">
                                    <i class="fa-solid fa-calendar-days"></i>
                                    <span class="text-nowrap flex-grow-1"></span>
                                </div>
                                <x-icon name="angle-down" class="text-muted flex-shrink-0"/>
                            </div>
                        </div>
                    </div>

                    {{-- Type Filter --}}
                    <div class="col-md-6 col-xl-auto">
                        <x-form.select name="type" label="{{ __('User Type') }}" class="form-select-md"
                                       :options="\App\Enums\UserRole::options()"
                                       :selected="request('type')"/>
                    </div>

                    {{-- Search Input --}}
                    <div class="col-md-6 col-xl-auto">
                        <div class="input-group">
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                   placeholder="{{ __('Search') }}">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            {{-- Transactions Table --}}
            <div class="table-responsive">
                <table class="table  border mb-0">
                    <thead class="table-light fw-semibold">
                    <tr class="align-middle text-nowrap">
                        <th>{{ __('User Info') }}</th>
                        <th>{{ __('IP Address') }}</th>
                        <th>{{ __('Country') }}</th>
                        <th>{{ __('Browser | Platform') }}</th>
                        <th>{{ __('Login Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($activities as $activity)
                        @php
                            $avatarData = getUserAvatarDetails($activity->user->first_name, $activity->user->last_name);
                        @endphp
                        <tr class="align-middle">
                            {{-- User Information --}}
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-md me-2">
                                        @isset($activity->user->avatar)
                                            <img class="avatar-img" src="{{ asset($activity->user->avatar) }}"
                                                 height="40" alt="User Avatar">
                                        @else
                                            <div class="avatar avatar-md {{ $avatarData['class'] }} text-white">
                                                {{ $avatarData['initials'] }}
                                            </div>
                                        @endisset
                                    </div>
                                    <div>
                                        <a href="{{ route('admin.user.manage', $activity->user->username) }}"
                                           class="text-decoration-none">
                                            {{ $activity->user->name }}
                                            <span class="badge badge-sm bg-{{ $activity->user->role->color() }}">{{ $activity->user->role->name }}</span>
                                        </a>
                                        <div class="small text-muted text-uppercase">
                                            <a class="text-decoration-none"
                                               href="{{ route('admin.user.manage',$activity->user->username) }}">{{ $activity->user->username }}</a>
                                        </div>
                                    </div>
                                </div>
                            </td>

                            <td>
                                {{ $activity->ip_address }}
                                <a href="https://whatismyipaddress.com/ip/{{ $activity->ip_address }}"
                                   target="_blank"
                                   class="btn btn-link p-0"
                                   data-coreui-toggle="tooltip"
                                   data-coreui-placement="top"
                                   title="Lookup IP">
                                    <i class="fa-solid fa-search"></i>
                                </a>
                            </td>


                            <td>
                                <div class="text-truncate">
                                    {{ $activity->country }}
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold">
                                    {{ $activity->browser }}
                                </div>
                                <div class="small text-muted">
                                    {{ $activity->platform }}
                                </div>
                            </td>
                            <td>
                                <div>{{ $activity->login_at->format('Y-m-d H:i') }}</div>
                                <div class="small text-muted">{{ $activity->login_at->diffForHumans() }}</div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-3">
                                <div class="text-center py-5">
                                    <x-icon name="no-data-found" height="200"/>
                                    <h5 class="text-muted mt-2">{{ __('No Data found') }}</h5>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            <div class="d-flex justify-content-end mt-3">
                {{ $activities->links() }}
            </div>
        </div>
    </div>
@endsection
