"use strict";

$(document).ready(function () {
    const $paymentCards = $(".payment-logo-card"),
        $payButton = $("#payButton"),
        $selectedMethodInput = $("#selectedMethod"),
        $walletID = $("#walletID"),
        $password = $("#password");

    // Payment Card Selection Handler
    $paymentCards.on("click", function () {
        $paymentCards.removeClass("selected").attr("aria-pressed", "false");
        $(this).addClass("selected").attr("aria-pressed", "true");

        $selectedMethodInput.val($(this).data("method"));
        $payButton.prop("disabled", false);
    });

    // Enable Keyboard Selection (Enter or Space key)
    $paymentCards.on("keydown", function (event) {
        if (event.key === "Enter" || event.key === " ") {
            event.preventDefault();
            $(this).trigger("click");
        }
    });

    // Form Input Validation for Enabling Pay Button
    $walletID.add($password).on("input", function () {
        $payButton.prop("disabled", !($walletID.val().trim().length > 8 && $password.val().trim().length >= 4));
    });
});
