"use strict";

(function ($) {
    $(document).ready(function () {

        /* Navbar Dropdown Link Prevent */
        $(document).on('click', '.navbar-area .navbar-nav li.menu-item-has-children > a', function (e) {
            e.preventDefault();
        });

        /* Search Popup */
        const $bodyOverlay = $('#body-overlay');
        const $searchPopup = $('#td-search-popup');
        const $searchBtn = $('.search-bar-btn');
        const $sidebarMenu = $('#sidebar-menu');

        $(document).on('click', '#body-overlay', function (e) {
            e.preventDefault();
            $bodyOverlay.removeClass('active');
            $searchPopup.removeClass('active');
            $sidebarMenu.removeClass('active');
        });

        $(document).on('click', '.search-bar-btn', function (e) {
            e.preventDefault();
            $searchPopup.toggleClass('active');
            $searchBtn.toggleClass('active');
        });

        /* Sidebar Menu */
        $(document).on('click', '.sidebar-menu-close', function (e) {
            e.preventDefault();
            $bodyOverlay.removeClass('active');
            $sidebarMenu.removeClass('active');
        });

        $(document).on('click', '#navigation-button', function (e) {
            e.preventDefault();
            $sidebarMenu.addClass('active');
            $bodyOverlay.addClass('active');
        });

        /* Wallet Slider */
        if ($('.walet-slider').length) {
            $('.walet-slider').owlCarousel({
                nav: true,
                margin: 5,
                dots: false,
                smartSpeed: 1500,
                items: 1,
                loop: false,
                autoplay: false,
                navText: [
                    '<i class="fa fa-angle-left mx-2"></i>',
                    '<i class="fa fa-angle-right"></i>'
                ],
                responsive: {
                    0: { items: 1 },
                    576: { items: 2 },
                    992: { items: 1 }
                }
            });
        }

        /* Back to Top Click */
        $(document).on('click', '.back-to-top', function () {
            $('html, body').animate({ scrollTop: 0 }, 2000);
        });

        /* User Dropdown Toggle */
        $('.navbar-area .header-right li .user').on('click', function (e) {
            e.stopPropagation();
            $(this).toggleClass('active');
        });

        /* Close User Dropdown on Outside Click */
        $(document).on('click', function (e) {
            if (!$(e.target).closest('.navbar-area .header-right li .user').length) {
                $('.navbar-area .header-right li .user').removeClass('active');
            }
        });

    });

    /* On Scroll Events */
    $(window).on('scroll', function () {
        const $scrollTopBtn = $('.back-to-top');
        if ($(window).scrollTop() > 1000) {
            $scrollTopBtn.fadeIn(1000);
        } else {
            $scrollTopBtn.fadeOut(1000);
        }
    });

    /* On Load Events */
    $(window).on('load', function () {
        const $preloader = $('#preloader');
        $preloader.fadeOut(0);

        $('.back-to-top').fadeOut();

        $(document).on('click', '.cancel-preloader a', function (e) {
            e.preventDefault();
            $preloader.fadeOut(2000);
        });
    });

    /* Initialize Bootstrap Tooltip */
    const tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    tooltipElements.forEach(function (el) {
        new bootstrap.Tooltip(el);
    });

    /* Initialize ClipboardJS */
    if (typeof ClipboardJS !== 'undefined') {
        const clipboard = new ClipboardJS('.copyNow');

        clipboard.on('success', function (e) {
            const button = e.trigger;
            const tooltip = bootstrap.Tooltip.getInstance(button);

            if (tooltip) {
                button.setAttribute('data-bs-original-title', 'Copied!');
                tooltip.show();

                setTimeout(() => {
                    const originalTitle = tooltip._config.title || '';
                    button.setAttribute('data-bs-original-title', originalTitle);
                }, 2000);
            }

            e.clearSelection();
        });
    }


})(jQuery);
