<?php

return [
    'general_settings' => [
        'title' => 'General Settings',
        'icon'  => 'cil-equalizer',

        'elements' => [
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'logo',
                'label' => 'Logo',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:1000',
                'value' => 'img/logo.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'light_logo',
                'label' => 'Light Logo',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:1000',
                'value' => 'img/logo.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'small_logo',
                'label' => 'Small Logo',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:1000',
                'value' => 'img/logo.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'site_favicon',
                'label' => 'Site Favicon',
                'rules' => 'mimes:jpeg,jpg,png,ico,,svg|max:1000',
                'value' => 'img/favicon.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'login_banner',
                'label' => 'Login Banner',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:2000',
                'value' => 'img/welcome-vector.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'default_breadcrumb_image',
                'label' => 'Default Breadcrumb Image',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:2000',
                'value' => 'img/welcome-vector.png',
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'site_title',
                'label' => 'Site Title',
                'rules' => 'required|min:2|max:500',
                'value' => 'Coevs',
                'class' => 'col-md-6',
            ],
            [
                'type'    => 'text',
                'data'    => 'string',
                'key'     => 'admin_prefix',
                'label'   => 'Admin Prefix',
                'rules'   => 'required|max:10',
                'value'   => 'admin',
                'class'   => 'col-md-6',
                'message' => 'Prefix for admin panel routes. When you change this, you need to Re login with the new prefix for it to take effect.',
            ],
            [
                'type'  => 'select',
                'data'  => 'string',
                'key'   => 'site_timezone',
                'label' => 'Site Timezone',
                'rules' => 'required',
                'value' => [],
                'class' => 'col-md-6',
            ],
            [
                'type'    => 'select',
                'data'    => 'string',
                'key'     => 'home_redirect',
                'label'   => 'Home Redirect',
                'rules'   => 'required',
                'value'   => [],
                'class'   => 'col-md-6',
                'message' => 'All Page Slugs',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'support_email',
                'label' => 'Support Email',
                'rules' => 'required|min:4|max:199',
                'value' => 'support@demo.com',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'support_phone',
                'label' => 'Support Phone',
                'rules' => 'required|min:4|max:199',
                'value' => '+1234567890',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'copyright_text',
                'label' => 'Copyright Text',
                'rules' => 'required|min:4|max:199',
                'value' => 'admin',
                'class' => 'col-md-12',
            ],

        ],
    ],
    'site_security' => [
        'title'    => 'Security Settings',
        'icon'     => 'security',
        'elements' => [
            [
                'type'  => 'switch',
                'data'  => 'bool',
                'key'   => 'force_https',
                'label' => 'Force HTTPS',
                'rules' => 'required|boolean',
                'value' => 0,
                'class' => 'col-md-3',
            ],
            [
                'type'  => 'hidden',
                'data'  => 'bool',
                'key'   => 'screen_lock',
                'rules' => 'required|boolean',
                'value' => 0,
            ],
            [
                'type'          => 'group_text',
                'data'          => 'integer',
                'key'           => 'screen_lock_time',
                'label'         => 'Screen Lock',
                'unit'          => 'minutes',
                'related_field' => 'screen_lock',
                'rules'         => 'required|integer',
                'value'         => 5,
                'class'         => 'col-md-5',
            ],
            [
                'type'  => 'group_text',
                'data'  => 'integer',
                'key'   => 'submission_lock_duration',
                'label' => 'Duplicate Submission Lock Duration',
                'unit'  => 'seconds',
                'info'  => 'Recommended value: 5',
                'rules' => 'required|integer',
                'value' => 5,
                'class' => 'col-md-4',
            ],
            [
                'type'  => 'group_text',
                'data'  => 'integer',
                'key'   => 'max_upload_size',
                'label' => 'Max Upload Size',
                'unit'  => 'MB',
                'rules' => 'required|integer|min:1',
                'value' => 5,
                'class' => 'col-md-4',
            ],
        ],
    ],

    'maintenance_mode' => [
        'title'     => 'Maintenance Mode Settings',
        'info'      => 'Caution: Enabling Maintenance Mode requires remembering the Secret Key to restore the website.',
        'info_icon' => 'fa fa-exclamation-triangle text-warning',
        'icon'      => 'cil-memory',
        'elements'  => [
            [
                'type'  => 'img',
                'data'  => 'string',
                'key'   => 'maintenance_cover',
                'label' => 'Cover Image',
                'rules' => 'mimes:jpeg,jpg,png,svg|max:2000',
                'value' => '',
                'class' => 'col-md-12',
            ],
            [
                'type'    => 'text',
                'data'    => 'string',
                'key'     => 'secret_key',
                'label'   => 'Secret Key',
                'rules'   => 'required',
                'value'   => 'secret',
                'class'   => 'col-md-12',
                'message' => 'Remember the secret key: domain/secret-key. Utilize it to restore the website live.',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'maintenance_title',
                'label' => 'Title',
                'rules' => 'required',
                'value' => 'Site is not under maintenance',
                'class' => 'col-md-12',
            ],
            [
                'type'  => 'textarea',
                'data'  => 'string',
                'key'   => 'maintenance_text',
                'label' => 'Maintenance Text',
                'rules' => 'required|max:500',
                'value' => 'Sorry for interrupt! Site will live soon.',
                'class' => 'col-md-12',
            ],
            [
                'type'  => 'select',
                'data'  => 'string',
                'key'   => 'site_environment',
                'label' => 'Site Environment',
                'rules' => 'required',
                'value' => [],
                'class' => 'col-md-12',
            ],
            [
                'type'    => 'switch',
                'data'    => 'bool',
                'key'     => 'development_mode',
                'label'   => 'Development Mode',
                'rules'   => 'boolean',
                'value'   => true,
                'class'   => 'col-md-6',
                'message' => 'Enable this feature only when debug or script changes are required',
            ],
            [
                'type'    => 'switch',
                'data'    => 'bool',
                'key'     => 'maintenance_mode',
                'label'   => 'Maintenance Mode',
                'rules'   => 'boolean',
                'value'   => 1,
                'class'   => 'col-md-6',
                'message' => 'Only activate it if you want the site to be in maintenance mode.',
            ],
        ],
    ],
    'mail_settings' => [
        'title' => 'SMTP Mail Settings',
        'info'  => 'When using Gmail SMTP, your custom "From Address" may be replaced automatically by your authenticated Gmail address due to security policies. 
                    To send emails with a custom address (like support@yourdomain.com), use a verified SMTP provider such as Mailgun, Amazon SES, or your domain\'s SMTP server with proper SPF, DKIM, and DMARC setup. 
                    A connection test will send a verification email to confirm your settings.',
        'icon'             => 'cil-send',
        'include_partials' => '_smtp_test',
        'elements'         => [
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'email_from_name',
                'label' => 'Email From Name',
                'rules' => 'required|max:50',
                'value' => 'Coevs',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'email_from_address',
                'label' => 'Email From Address',
                'rules' => 'required|min:5|max:50',
                'value' => 'coevs@gmail.com',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'mail_username',
                'label' => 'Mail Username',
                'rules' => 'required',
                'value' => 'test',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'mail_password',
                'label' => 'Mail Password',
                'rules' => 'required',
                'value' => '0000',
                'class' => 'col-md-6',
            ],

            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'mail_host',
                'label' => 'Mail Host',
                'rules' => 'required',
                'value' => 'mail.coevs.co',
                'class' => 'col-md-6',
            ],
            [
                'type'  => 'text',
                'data'  => 'integer',
                'key'   => 'mail_port',
                'label' => 'Mail Port',
                'rules' => 'required',
                'value' => '465',
                'class' => 'col-md-3',
            ],
            [
                'type'  => 'select',
                'data'  => 'string',
                'key'   => 'mail_secure',
                'label' => 'Encryption',
                'rules' => 'required',
                'value' => [],
                'class' => 'col-md-3',
            ],
        ],
    ],
    'cookie_settings' => [
        'title'    => 'Cookie Settings',
        'icon'     => 'cil-bug',
        'elements' => [
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'cookie_title',
                'label' => 'Cookie Title',
                'rules' => 'required',
                'value' => 'Cookies Consent',
                'class' => 'col-md-12',
            ],
            [
                'type'  => 'textarea',
                'data'  => 'string',
                'key'   => 'cookie_summary',
                'label' => 'Cookie Summary',
                'rules' => 'required',
                'value' => 'This website use cookies to help you have a superior and more relevant browsing experience on the website.',
                'class' => 'col-md-12',
            ],
            [
                'type'  => 'text',
                'data'  => 'string',
                'key'   => 'cookie_url',
                'label' => 'Cookie Page Url',
                'rules' => 'required',
                'value' => '/',
                'class' => 'col-md-12',
            ],
            [
                'type'  => 'switch',
                'data'  => 'bool',
                'key'   => 'cookie_status',
                'label' => 'Enable Cookie',
                'rules' => 'boolean',
                'value' => true,
                'class' => 'col-md-6',
            ],
        ],
    ],
    'hide_settings' => [
        'title'    => 'hide',
        'elements' => [
            [
                'data'  => 'bool',
                'key'   => 'deposit_rewards',
                'rules' => 'boolean',
                'value' => true,
            ],
            [
                'data'  => 'bool',
                'key'   => 'payment_rewards',
                'rules' => 'boolean',
                'value' => true,
            ],
        ],
    ],
];
