<?php

namespace App\Observers;

use App\Enums\MerchantStatus;
use App\Models\Merchant;
use Illuminate\Support\Str;

class MerchantObserver
{
    /*
    public function creating(Merchant $merchant): void
    {
        \Log::info('[Observer] creating merchant...', [
            'before' => $merchant->toArray()
        ]);
    
        $merchant->api_key      = $merchant->api_key      ?? Str::random(28);
        $merchant->api_secret   = $merchant->api_secret   ?? Str::random(38);
        $merchant->merchant_key = $merchant->merchant_key ?? Str::random(12);
        $merchant->status       = $merchant->status       ?? MerchantStatus::PENDING;
    
        \Log::info('[Observer] after assign keys', [
            'after' => $merchant->toArray()
        ]);
    }
    */
    public function creating(Merchant $merchant): void
    {
        if (is_null($merchant->getRawOriginal('api_key'))) {
            $merchant->api_key = Str::random(28);
        }
    
        if (is_null($merchant->getRawOriginal('api_secret'))) {
            $merchant->api_secret = Str::random(38);
        }
    
        if (is_null($merchant->getRawOriginal('merchant_key'))) {
            $merchant->merchant_key = Str::random(12);
        }
    
        if (is_null($merchant->getRawOriginal('status'))) {
            $merchant->status = MerchantStatus::PENDING;
        }
    }

}
